using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class DlgCTRatioReportCriteria
	/// </summary>
	public class DlgCTRatioReportCriteria : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		private BOL.CTRatioReport _report;
		//
		private System.Windows.Forms.GroupBox grpDateRange;
		private System.Windows.Forms.Label lblEndDate;
		private System.Windows.Forms.Label lblStartDate;
		private System.Windows.Forms.DateTimePicker dtpStartDate;
		private System.Windows.Forms.DateTimePicker dtpEndDate;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private System.Windows.Forms.Button btnCancel;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.GroupBox grpType;
		private System.Windows.Forms.RadioButton rdoDetailed;
		private System.Windows.Forms.RadioButton rdoDetailedPhysician;
		private System.Windows.Forms.RadioButton rdoDetailedSpecialty;
		private System.Windows.Forms.RadioButton rdoPhysician;
		private System.Windows.Forms.RadioButton rdoSpecialty;
		private System.Windows.Forms.PictureBox pictureBox1;
		private System.Windows.Forms.GroupBox grpReportCompilation;
		private System.Windows.Forms.RadioButton rdoScheduleJob;
		private System.Windows.Forms.RadioButton rdoCreateNow;
		private System.Windows.Forms.GroupBox grpScheduleJob;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbPrinterName;
		private System.Windows.Forms.Label lblPrinterName;
		private System.Windows.Forms.Label lblPrintDate;
		private System.Windows.Forms.DateTimePicker dtpPrintDate;
		private System.Windows.Forms.GroupBox grpDivision;
		private System.Windows.Forms.RadioButton rdoAllDivisions;
		private System.Windows.Forms.RadioButton rdoCurrentDivision;
		private System.ComponentModel.IContainer components = null;

		/// <summary>
		/// Constructor
		/// </summary>
		public DlgCTRatioReportCriteria()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			this._report = new BOL.CTRatioReport();
			this._report.Valid += new System.EventHandler(this.CheckValid);
			this._report.Invalid += new System.EventHandler(this.CheckValid);
			this._report.IsDirtyChanged += new System.EventHandler(this.CheckValid);
			this._report.SetInitialBrokenRules(this.Name);

			SetComponentProperties();
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(DlgCTRatioReportCriteria));
			this.grpDateRange = new System.Windows.Forms.GroupBox();
			this.lblEndDate = new System.Windows.Forms.Label();
			this.lblStartDate = new System.Windows.Forms.Label();
			this.dtpStartDate = new System.Windows.Forms.DateTimePicker();
			this.dtpEndDate = new System.Windows.Forms.DateTimePicker();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.btnCancel = new System.Windows.Forms.Button();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.grpDivision = new System.Windows.Forms.GroupBox();
			this.rdoAllDivisions = new System.Windows.Forms.RadioButton();
			this.rdoCurrentDivision = new System.Windows.Forms.RadioButton();
			this.grpType = new System.Windows.Forms.GroupBox();
			this.rdoSpecialty = new System.Windows.Forms.RadioButton();
			this.rdoPhysician = new System.Windows.Forms.RadioButton();
			this.rdoDetailedSpecialty = new System.Windows.Forms.RadioButton();
			this.rdoDetailedPhysician = new System.Windows.Forms.RadioButton();
			this.rdoDetailed = new System.Windows.Forms.RadioButton();
			this.grpReportCompilation = new System.Windows.Forms.GroupBox();
			this.rdoScheduleJob = new System.Windows.Forms.RadioButton();
			this.rdoCreateNow = new System.Windows.Forms.RadioButton();
			this.grpScheduleJob = new System.Windows.Forms.GroupBox();
			this.cmbPrinterName = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblPrinterName = new System.Windows.Forms.Label();
			this.lblPrintDate = new System.Windows.Forms.Label();
			this.dtpPrintDate = new System.Windows.Forms.DateTimePicker();
			this.grpDateRange.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.grpDivision.SuspendLayout();
			this.grpType.SuspendLayout();
			this.grpReportCompilation.SuspendLayout();
			this.grpScheduleJob.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(404, 30);
			this.vbecsLogo1.TabIndex = 6;
			this.vbecsLogo1.Title = "C:T Ratio Report";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 405);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 8;
			// 
			// grpDateRange
			// 
			this.grpDateRange.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDateRange.Controls.Add(this.lblEndDate);
			this.grpDateRange.Controls.Add(this.lblStartDate);
			this.grpDateRange.Controls.Add(this.dtpStartDate);
			this.grpDateRange.Controls.Add(this.dtpEndDate);
			this.grpDateRange.Location = new System.Drawing.Point(60, 32);
			this.grpDateRange.Name = "grpDateRange";
			this.grpDateRange.Size = new System.Drawing.Size(340, 48);
			this.grpDateRange.TabIndex = 0;
			this.grpDateRange.TabStop = false;
			this.grpDateRange.Text = "Report Date Range";
			// 
			// lblEndDate
			// 
			this.lblEndDate.Location = new System.Drawing.Point(176, 20);
			this.lblEndDate.Name = "lblEndDate";
			this.lblEndDate.Size = new System.Drawing.Size(56, 20);
			this.lblEndDate.TabIndex = 2;
			this.lblEndDate.Text = "End Date*";
			this.lblEndDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblStartDate
			// 
			this.lblStartDate.Location = new System.Drawing.Point(8, 20);
			this.lblStartDate.Name = "lblStartDate";
			this.lblStartDate.Size = new System.Drawing.Size(60, 20);
			this.lblStartDate.TabIndex = 0;
			this.lblStartDate.Text = "Start Date*";
			this.lblStartDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpStartDate
			// 
			this.dtpStartDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpStartDate.CustomFormat = "MM/dd/yyyy";
			this.dtpStartDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpStartDate.Location = new System.Drawing.Point(68, 20);
			this.dtpStartDate.Name = "dtpStartDate";
			this.dtpStartDate.Size = new System.Drawing.Size(88, 20);
			this.dtpStartDate.TabIndex = 1;
			this.dtpStartDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			this.dtpStartDate.ValueChanged += new System.EventHandler(this.StartDateChanged);
			// 
			// dtpEndDate
			// 
			this.dtpEndDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpEndDate.CustomFormat = "MM/dd/yyyy";
			this.dtpEndDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpEndDate.Location = new System.Drawing.Point(232, 20);
			this.dtpEndDate.Name = "dtpEndDate";
			this.dtpEndDate.Size = new System.Drawing.Size(88, 20);
			this.dtpEndDate.TabIndex = 3;
			this.dtpEndDate.Value = new System.DateTime(2004, 4, 7, 0, 0, 0, 0);
			this.dtpEndDate.ValueChanged += new System.EventHandler(this.EndDateChanged);
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = null;
			this.btnOK.Location = new System.Drawing.Point(244, 388);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 4;
			this.btnOK.Click += new System.EventHandler(this.ClickOK);
			this.btnOK.MouseHover += new System.EventHandler(this.HoverOK);
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnCancel.Location = new System.Drawing.Point(324, 388);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 5;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.ClickCancel);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 349);
			this.grpImage.TabIndex = 7;
			this.grpImage.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 12);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(45, 45);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// grpDivision
			// 
			this.grpDivision.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpDivision.Controls.Add(this.rdoAllDivisions);
			this.grpDivision.Controls.Add(this.rdoCurrentDivision);
			this.grpDivision.Location = new System.Drawing.Point(60, 80);
			this.grpDivision.Name = "grpDivision";
			this.grpDivision.Size = new System.Drawing.Size(340, 60);
			this.grpDivision.TabIndex = 1;
			this.grpDivision.TabStop = false;
			this.grpDivision.Text = "Division*";
			// 
			// rdoAllDivisions
			// 
			this.rdoAllDivisions.Location = new System.Drawing.Point(12, 36);
			this.rdoAllDivisions.Name = "rdoAllDivisions";
			this.rdoAllDivisions.Size = new System.Drawing.Size(144, 20);
			this.rdoAllDivisions.TabIndex = 1;
			this.rdoAllDivisions.Text = "&All Divisions";
			this.rdoAllDivisions.CheckedChanged += new System.EventHandler(this.DivisionsChanged);
			// 
			// rdoCurrentDivision
			// 
			this.rdoCurrentDivision.Checked = true;
			this.rdoCurrentDivision.Location = new System.Drawing.Point(12, 16);
			this.rdoCurrentDivision.Name = "rdoCurrentDivision";
			this.rdoCurrentDivision.Size = new System.Drawing.Size(144, 20);
			this.rdoCurrentDivision.TabIndex = 0;
			this.rdoCurrentDivision.TabStop = true;
			this.rdoCurrentDivision.Text = "Current &Division";
			this.rdoCurrentDivision.CheckedChanged += new System.EventHandler(this.DivisionsChanged);
			// 
			// grpType
			// 
			this.grpType.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpType.Controls.Add(this.rdoSpecialty);
			this.grpType.Controls.Add(this.rdoPhysician);
			this.grpType.Controls.Add(this.rdoDetailedSpecialty);
			this.grpType.Controls.Add(this.rdoDetailedPhysician);
			this.grpType.Controls.Add(this.rdoDetailed);
			this.grpType.Location = new System.Drawing.Point(60, 140);
			this.grpType.Name = "grpType";
			this.grpType.Size = new System.Drawing.Size(340, 120);
			this.grpType.TabIndex = 2;
			this.grpType.TabStop = false;
			this.grpType.Text = "Report Sections*";
			// 
			// rdoSpecialty
			// 
			this.rdoSpecialty.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoSpecialty.Location = new System.Drawing.Point(12, 56);
			this.rdoSpecialty.Name = "rdoSpecialty";
			this.rdoSpecialty.Size = new System.Drawing.Size(316, 20);
			this.rdoSpecialty.TabIndex = 2;
			this.rdoSpecialty.Text = "&Treating Specialty Summary Report";
			// 
			// rdoPhysician
			// 
			this.rdoPhysician.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoPhysician.Location = new System.Drawing.Point(12, 36);
			this.rdoPhysician.Name = "rdoPhysician";
			this.rdoPhysician.Size = new System.Drawing.Size(316, 20);
			this.rdoPhysician.TabIndex = 1;
			this.rdoPhysician.Text = "&Physician Summary Report";
			// 
			// rdoDetailedSpecialty
			// 
			this.rdoDetailedSpecialty.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoDetailedSpecialty.Location = new System.Drawing.Point(12, 96);
			this.rdoDetailedSpecialty.Name = "rdoDetailedSpecialty";
			this.rdoDetailedSpecialty.Size = new System.Drawing.Size(316, 20);
			this.rdoDetailedSpecialty.TabIndex = 4;
			this.rdoDetailedSpecialty.Text = "Det&ailed Report with Treating Specialty Summary";
			// 
			// rdoDetailedPhysician
			// 
			this.rdoDetailedPhysician.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoDetailedPhysician.Location = new System.Drawing.Point(12, 76);
			this.rdoDetailedPhysician.Name = "rdoDetailedPhysician";
			this.rdoDetailedPhysician.Size = new System.Drawing.Size(316, 20);
			this.rdoDetailedPhysician.TabIndex = 3;
			this.rdoDetailedPhysician.Text = "D&etailed Report with Physician Summary";
			// 
			// rdoDetailed
			// 
			this.rdoDetailed.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.rdoDetailed.Checked = true;
			this.rdoDetailed.Location = new System.Drawing.Point(12, 16);
			this.rdoDetailed.Name = "rdoDetailed";
			this.rdoDetailed.Size = new System.Drawing.Size(316, 20);
			this.rdoDetailed.TabIndex = 0;
			this.rdoDetailed.TabStop = true;
			this.rdoDetailed.Text = "Detailed &Report";
			this.rdoDetailed.CheckedChanged += new System.EventHandler(this.ReportSectionsChanged);
			// 
			// grpReportCompilation
			// 
			this.grpReportCompilation.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpReportCompilation.Controls.Add(this.rdoScheduleJob);
			this.grpReportCompilation.Controls.Add(this.rdoCreateNow);
			this.grpReportCompilation.Controls.Add(this.grpScheduleJob);
			this.grpReportCompilation.Location = new System.Drawing.Point(60, 260);
			this.grpReportCompilation.Name = "grpReportCompilation";
			this.grpReportCompilation.Size = new System.Drawing.Size(340, 120);
			this.grpReportCompilation.TabIndex = 3;
			this.grpReportCompilation.TabStop = false;
			this.grpReportCompilation.Text = "Report Compilation*";
			// 
			// rdoScheduleJob
			// 
			this.rdoScheduleJob.Location = new System.Drawing.Point(16, 40);
			this.rdoScheduleJob.Name = "rdoScheduleJob";
			this.rdoScheduleJob.Size = new System.Drawing.Size(120, 16);
			this.rdoScheduleJob.TabIndex = 1;
			this.rdoScheduleJob.Text = "&Schedule Print Job";
			this.rdoScheduleJob.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// rdoCreateNow
			// 
			this.rdoCreateNow.Checked = true;
			this.rdoCreateNow.Location = new System.Drawing.Point(16, 20);
			this.rdoCreateNow.Name = "rdoCreateNow";
			this.rdoCreateNow.Size = new System.Drawing.Size(124, 16);
			this.rdoCreateNow.TabIndex = 0;
			this.rdoCreateNow.TabStop = true;
			this.rdoCreateNow.Text = "Create Report &Now";
			this.rdoCreateNow.CheckedChanged += new System.EventHandler(this.ReportCompilationChanged);
			// 
			// grpScheduleJob
			// 
			this.grpScheduleJob.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpScheduleJob.Controls.Add(this.cmbPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrinterName);
			this.grpScheduleJob.Controls.Add(this.lblPrintDate);
			this.grpScheduleJob.Controls.Add(this.dtpPrintDate);
			this.grpScheduleJob.Enabled = false;
			this.grpScheduleJob.Location = new System.Drawing.Point(8, 40);
			this.grpScheduleJob.Name = "grpScheduleJob";
			this.grpScheduleJob.Size = new System.Drawing.Size(324, 72);
			this.grpScheduleJob.TabIndex = 2;
			this.grpScheduleJob.TabStop = false;
			// 
			// cmbPrinterName
			// 
			this.cmbPrinterName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbPrinterName.Interval = 500;
			this.cmbPrinterName.Location = new System.Drawing.Point(96, 44);
			this.cmbPrinterName.MaxLength = 50;
			this.cmbPrinterName.Name = "cmbPrinterName";
			this.cmbPrinterName.Size = new System.Drawing.Size(208, 22);
			this.cmbPrinterName.TabIndex = 3;
			this.cmbPrinterName.SelectedIndexChanged += new System.EventHandler(this.PrinterNameChanged);
			// 
			// lblPrinterName
			// 
			this.lblPrinterName.Location = new System.Drawing.Point(24, 44);
			this.lblPrinterName.Name = "lblPrinterName";
			this.lblPrinterName.Size = new System.Drawing.Size(76, 20);
			this.lblPrinterName.TabIndex = 2;
			this.lblPrinterName.Text = "Printer Name*";
			this.lblPrinterName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblPrintDate
			// 
			this.lblPrintDate.Location = new System.Drawing.Point(24, 20);
			this.lblPrintDate.Name = "lblPrintDate";
			this.lblPrintDate.Size = new System.Drawing.Size(72, 20);
			this.lblPrintDate.TabIndex = 0;
			this.lblPrintDate.Text = "Print Date*";
			this.lblPrintDate.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// dtpPrintDate
			// 
			this.dtpPrintDate.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpPrintDate.CalendarFont = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.dtpPrintDate.CustomFormat = "MM/dd/yyyy hh:mm";
			this.dtpPrintDate.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpPrintDate.Location = new System.Drawing.Point(96, 20);
			this.dtpPrintDate.Name = "dtpPrintDate";
			this.dtpPrintDate.Size = new System.Drawing.Size(208, 20);
			this.dtpPrintDate.TabIndex = 1;
			this.dtpPrintDate.Value = new System.DateTime(2003, 6, 20, 15, 24, 4, 467);
			this.dtpPrintDate.ValueChanged += new System.EventHandler(this.PrintDateChanged);
			// 
			// DlgCTRatioReportCriteria
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(404, 421);
			this.Controls.Add(this.grpReportCompilation);
			this.Controls.Add(this.grpType);
			this.Controls.Add(this.grpDivision);
			this.Controls.Add(this.grpDateRange);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.grpImage);
			this.hlphelpChm.SetHelpKeyword(this, "C_T_Ratio_Report.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.MinimumSize = new System.Drawing.Size(412, 448);
			this.Name = "DlgCTRatioReportCriteria";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - C:T Ratio Report";
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.grpDateRange, 0);
			this.Controls.SetChildIndex(this.grpDivision, 0);
			this.Controls.SetChildIndex(this.grpType, 0);
			this.Controls.SetChildIndex(this.grpReportCompilation, 0);
			this.grpDateRange.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.grpDivision.ResumeLayout(false);
			this.grpType.ResumeLayout(false);
			this.grpReportCompilation.ResumeLayout(false);
			this.grpScheduleJob.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gets CT ratio report object
		/// </summary>
		public BOL.CTRatioReport CTRatioReport
		{
			get
			{
				return this._report;
			}
		}

		private void SetComponentProperties()
		{
			this.vbecsLogo1.Title = this.Text.Replace("VBECS - ","");
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC104.DlgCTRatioReportCriteria());
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			//
			this.btnOK.Text = "&OK";
			//
			this.SetThisToolTip(btnCancel,Common.StrRes.Tooltips.Common.Cancel());
			//
			this.dtpStartDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpEndDate.CustomFormat = Common.VBECSDateTime.DateFormat;
			this.dtpPrintDate.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			System.DateTime currentDate = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			//BR_77.01
			this.dtpStartDate.Value = this._report.StartDate;
			this.dtpEndDate.Value = this._report.EndDate;
			this.dtpPrintDate.Value = currentDate;

			if (ThisUser.DivisionsAndRoles.EffectiveDivisions.Count == 1)
			{
				this.rdoAllDivisions.Enabled = false;
			}

			LoadPrinters();
		}

		private void LoadPrinters()
		{
			this.cmbPrinterName.Items.Clear();
			//
			foreach (string printerName in BOL.VbecsReport.GetPrinters())
			{
				cmbPrinterName.Items.Add(printerName);
			}
		}

		private void ReportCompilationChanged(object sender, System.EventArgs e)
		{
			this._report.IsScheduled = (this.rdoScheduleJob.Checked);
			this.grpScheduleJob.Enabled = (this.rdoScheduleJob.Checked);
			if ((this._report.IsScheduled) && (this._report.PrintDate == DateTime.MinValue))
			{
				this.dtpPrintDate.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
			}
		}

		private void ClickOK(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if (this._report.IsScheduledReportGreaterThanThirtyDays)
				{
					if (DialogResult.Yes != GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.Common.ScheduledReportGreaterThanThirtyDays()))
					{
						return;
					}
				}
				try
				{
					this._report.Schedule();
					this.DialogResult = DialogResult.Cancel;
				}
				catch(BOL.BusinessObjectException)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.ScheduleReportFailed());
					return;
				}
			}
			else
			{
				int count = this._report.GetCTRatioReportCount();
				//
				if(count==0)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.NoInfoReturned());
					return;
				}
				else if((count/20)>=50) //assuming 20 records per page
				{
					DialogResult _result = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC049.PageCountAlert());
					if( _result != DialogResult.Yes )
					{
						return;
					}
					else
					{
						//Alert user that building report may take a few minutes
						GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC049.Warning());
					}
				}
				//
				this.DialogResult = DialogResult.OK;
			}
			this.Close();
		}

		private void ClickCancel(object sender, System.EventArgs e)
		{
			this.Close();
		}

		private void DivisionsChanged(object sender, System.EventArgs e)
		{
			this._report.IsMultiDivisional = (this.rdoAllDivisions.Checked);
		}

		private void PrintDateChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				this._report.PrintDate = this.dtpPrintDate.Value;
			}
			//
			CheckDates();
		}

		private void PrinterNameChanged(object sender, System.EventArgs e)
		{
			if (this._report.IsScheduled)
			{
				if(cmbPrinterName.SelectedItem!=null)
				{
					string printer=this.cmbPrinterName.Text;
					for(int i=0; i<this.cmbPrinterName.Items.Count; i++)
					{
						if(printer==this.cmbPrinterName.Items[i].ToString())
						{
							this._report.PrinterName = cmbPrinterName.SelectedItem.ToString();
						}
					}
				}		
				else
				{
					this._report.PrinterName=String.Empty;
				}
			}
		}

		private void CheckValid(object sender, System.EventArgs e)
		{
			this.btnOK.EnabledButton = (this._report.IsValid);
		}

		private void CheckDates()
		{
			if (this._report.StartDate > this._report.EndDate)
			{
				this.errError.SetVbecsError(this.dtpEndDate,Common.StrRes.SysErrMsg.Common.CannotbeGreaterError("Start date","End date").ResString); // **** 508 Compliance ***
			}
			else
			{
				this.errError.SetVbecsError(this.dtpEndDate, ""); // **** 508 Compliance ***
			}
			//
			if (this._report.IsScheduled)
			{
				if (this._report.EndDate > this._report.PrintDate)
				{
					this.errError.SetVbecsError(this.dtpPrintDate,Common.StrRes.SysErrMsg.Common.CannotbeLessError("Print date","End date").ResString); // **** 508 Compliance ***
				}
				else
				{
					this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
				}
			}
			else
			{
				this.errError.SetVbecsError(this.dtpPrintDate, ""); // **** 508 Compliance ***
			}
		}

		private void StartDateChanged(object sender, System.EventArgs e)
		{
			this._report.StartDate = this.dtpStartDate.Value;
			//
			CheckDates();
		}

		private void EndDateChanged(object sender, System.EventArgs e)
		{
			this._report.EndDate = this.dtpEndDate.Value;
			//
			CheckDates();
		}

		private void HoverOK(object sender, System.EventArgs e)
		{
			if (this._report.IsValid)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.OKToContinue().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(this._report.GetBrokenRulesMessage(this.Name));
			}
		}

		private void ReportSectionsChanged(object sender, System.EventArgs e)
		{
			this._report.IncludeDetailedReport = (this.rdoDetailed.Checked || this.rdoDetailedPhysician.Checked || this.rdoDetailedSpecialty.Checked);
			this._report.IncludePhysicianSummary = (this.rdoPhysician.Checked || this.rdoDetailedPhysician.Checked);
			this._report.IncludeSpecialtySummary = (this.rdoSpecialty.Checked || this.rdoDetailedSpecialty.Checked);
		}
	}
}

